/*	Formatright  2009, OT

	Transparent Walls Block is free software;
	you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Migraine; if not, write to the
	Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	Boston, MA 02111-1307, USA.
*/

/*  [Description]
	This plugin blocks wallhacks by blocking entity data transmition when entities can't be seen.
	This plugin does not affect sounds!
*/


/*  [Features]
* Player non visibility transfer block
If the player does not see one of the points in the visibility plane of a player the player will not be transmitted therefore becoming invisible for transparent wall cheats.
* Smooth engine
The plugin adds prediction to player movement, it will make players not pop (appear out of nowhere).
* FOV Check
The plugins checks if the players are in front of us or not, if not the players will not be transmitted, it helps when we talk about CPU efficiency and also for cheats that show the player in 3rd person view.
* Transparent entity detection and storage base
It checks if we can see through an entity and it will modify it's properties so that the traces will not be influenced by it! The players will not notice anything!
* Grenade and weapon transfer block
The plugin will block entities like grenades and weapons when they are not seen.
* Support for dynamic cameras
The plugin will detect when a player uses a camera and will not affect the visibility.
* Calculations matrix
You can set the ammount of calculations dependint on your CPU power.
* Distortion wave
It works on a new and different principle, when not seeing players the plugin sets a random origin that makes hard for you to know where the player is.
*/

/*  [Unfixable bugs]
* Player popping
There is a risk that player pops out of nowhere, but the chance is small.
* Player lag late appearance
If the players have lag the plugin will make it even more difficult for them to play.
*/

/*  [Installation]
	1. Unzip the file "trw_block" in the "<target>/cstrike" folder
	2. Add the plugin to plugins.ini.
	3. Enjoy!
*/
 
/*  [Cvars]
	trw_enable 1 					// Enable Plugin
	trw_ignoreteam 1 				// Ignore Teammates
	trw_block_ents 1 				// Block entities such as ground weapons and grenades, use 2 for more calculations.
	trw_fov_check 1 				// Check if the player is in the back of the player
	trw_target_check 1 				// Do not do any checks if you have aimed on the player
	trw_smooth_check 1 				// It prevents player poping
	trw_textureallow 1 				// It will ignore entities that can be seen through!
	trw_calculations 2 				// This sets the ammount of plane calculations on the player do not set this more than 4
	trw_player_distort_radius 1500	// This sets the distance that an player has to be from the player to apply the distortion wave function. This must have bigger values than 1000!
	trw_entity_distort_radius 500	// This sets the distance that an entity has to be from the player to apply the distortion wave function. This must have medium values, smaller than 1000!
*/

/*  [Plugin Link]
	https://forums.alliedmods.net/showthread.php?t=100886
*/

/*  [Changelog]
- 6.0 - separated the features in separate plugins, 100% cpu usage problem improvement, fixed texture problem that crashes the server, more stable and faster
- 5.6 - Fixed the amxx crash bug when soundkey has been used
- 5.5 - Changed the way the command of creating soundkey works, added log to files, added more cvars for configuration, and miscelanous things
- 5.4 - Anti-Soundhack shot, pick-up and spawn
- 5.3 - Separated the channels from the shot mechanism (now we have the sound of the shot, the bullet particles and the weapon animation separated!)
- 5.2 - Fixed double jump/land sound, made the soundkey use less resources if the sounds that are used are default, removed PVS cvar (useless), new cvar wallblocker_footsteps
- 5.1 - PreHook fix, EmitAmbientSound function used, update key (more random and better when dealing with problems!)
- 5.0 - Added anti-soundhack based with key, made the ents follow the players much closer
- 4.8 - Less crash risk, new method of detecting transparent ents and making them transperent will not destroy ladded functionality anymore!!!
- 4.5 - texture check now isn't made that often (less crash risk!), added texture check autodisable cfg, added a new method to ignore entities that are transparent (100% efficient), reupdated the weapon headpoint
- 4.2 - added bitsum remember system, smooth check is made now by FRAME_CONSTANT (1/48), changed alive/dead recognision system (less resource use!)
- 4.1 - fixed plugin_init problem!
- 4.0 - all bugs fixed, added texture check , everything tweaked and tuned!
- 3.0 - removed Engine module (another method), improved smooth engine, removed , fixed flashing bug, target check now works both ways (if you are seen the player will be shown!)
- 2.5 - removed HamSandWich module (useless), improved smooth check, corpse remove bug fixed, optimized the code a little bit.
- 2.4 - bug fix release (weapon index out of bounds fix, reconnect bug fix (with CSDM), made the ent check not so sensitive (not so many blind-spots)
- 2.2 - bug fix release (index out of bounds & weapon confusion bug)
- 2.1 - removed a bugged feature (block_dead cvar), added smooth cvar
- 2.0 - more customizable, less cpu usage (50% TESTED!), weapons grenades check added, bug fixes
- 1.5 - removed some checks, optimized it a bit, added weapon head-point check
- 1.0 - initial release 
*/

/*  [Credits]
- joropito - for compiling engineX on linux
- hlstriker - for finding the way to detect semi-transparent textures!
- h010c - for tests and benchmarks, anti-soundhack tests and code samples
- joaquimandrade - for pointing out the plugin flaws, and for the Orpheu module
- Arkshine - for finding precise weapon head points, and for some sig files
- Mnx Community - for letting me test this plugin on linux!
- turshija - for some small suggestions.
- .Owyn. - bug reports
- ShlumPF* - for small improvements (initial v1.0)
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include <engine>
#include <hamsandwich>

#define PLUGIN	"TRW Block"
#define AUTHOR	"OT"
#define VERSION	"6.0"

#define MAX_PLAYERS							32
#define FRAME_OFFSET_CONSTANT				0.0208

new const Float:gV_BlockOrigin[3] = {-20000.0, -20000.0, -20000.0}

new const Float:gF_WeaponEdge[CSW_P90+1] =
{
    0.00, // nothing
    32.8, // p228 
    0.00, // shield
    38.9, // scout
    0.00, // hegrenade
    31.2, // xm1014
    0.00, // c4
    26.0, // mac10
    32.9, // aug
    0.00, // smokegrenade
    23.5, // elite
    32.7, // fiveseven  
    27.0, // ump45
    40.0, // sg550   
    26.5, // galil
    32.6, // famas    
    38.9, // usp ( without silencer 23.5 )
    32.6, // glock     
    39.5, // awp     
    30.4, // mp5        
    30.5, // m249
    30.1, // m3    
    41.4, // m4a1 ( without silencer 32.6 )
    39.2, // tmp         
    42.2, // g3sg1      
    0.00, // flashbang
    34.1, // deagle  
    34.0, // sg552   
    24.8, // ak47       
    0.00, // knife
    25.4  // p90
}

enum Property
{
	PROP_ALIVE,
	PROP_CONNECT,
	PROP_BOT
}

new gBS_Properties[Property]

#define add_user_property(%0,%1) 			gBS_Properties[%1] |= (1<<(%0 - 1))
#define del_user_property(%0,%1) 			gBS_Properties[%1] &= ~(1<<(%0 - 1))
#define has_user_property(%0,%1)			(gBS_Properties[%1] & (1<<(%0 - 1)))

new gEP_Visibility[MAX_PLAYERS + 1], gEP_Team[MAX_PLAYERS + 1], gEP_Weapon[MAX_PLAYERS + 1], gEP_ViewEnt[MAX_PLAYERS + 1], gBSP_Targets[MAX_PLAYERS + 1], gBSP_AddOffset[MAX_PLAYERS + 1] = {~0, ...}, gBSP_IgnoreOnce[MAX_PLAYERS + 1], gBSP_IgnoreTwo[MAX_PLAYERS + 1] // ~0 = -4294967295

// %0 is the player that targets, is seen by , can smooth
#define add_TargetedPlayer(%0,%1)			gBSP_Targets[%0] |= (1<<(%1 - 1))
#define del_TargetedPlayer(%0,%1)			gBSP_Targets[%0] &= ~(1<<(%1 - 1))
#define is_TargetedPlayer(%0,%1)			(gBSP_Targets[%0] & (1<<(%1 - 1)))
#define add_OffsetBetween(%0,%1)			gBSP_AddOffset[%0] |= (1<<(%1 - 1))
#define del_OffsetBetween(%0,%1)			gBSP_AddOffset[%0] &= ~(1<<(%1 - 1))
#define has_OffsetBetween(%0,%1)			(gBSP_AddOffset[%0] & (1<<(%1 - 1)))
#define make_IgnoreOnce(%0,%1)				gBSP_IgnoreOnce[%0] |= (1<<(%1 - 1))
#define stop_IgnoreOnce(%0,%1)				gBSP_IgnoreOnce[%0] &= ~(1<<(%1 - 1))
#define can_IgnoreOnce(%0,%1)				(gBSP_IgnoreOnce[%0] & (1<<(%1 - 1)))
#define make_IgnoreTwo(%0,%1)				gBSP_IgnoreTwo[%0] |= (1<<(%1 - 1))
#define stop_IgnoreTwo(%0,%1)				gBSP_IgnoreTwo[%0] &= ~(1<<(%1 - 1))
#define can_IgnoreTwo(%0,%1)				(gBSP_IgnoreTwo[%0] & (1<<(%1 - 1)))

// Pointer Cvars, Cached Cvars
new gPCV_enable, gPCV_ignore_team, gPCV_blockents, gPCV_target, gPCV_smooth, gPCV_texture, gPCV_calcs, gPCV_fovcheck, gPCV_distort, gPCV_edistort
new gCCV_enable, gCCV_ignore_team, gCCV_blockents, gCCV_target, gCCV_smooth, gCCV_texture, gCCV_calcs, gCCV_fovcheck, Float:gCCV_distortRadius, Float:gCCV_distortERadius

// Trace Handle and MaxPlayers
new gTraceHandle
new gI_MaxPlayers

// These bitsums allow 4096 entities storage. I think that it is enough :P
// BitSum, This is equal to 128*32 bools (good for quick search)

new gBSA_Solids[128]
new gBSA_Transparents[128]
new gBSA_RenderInfo[kRenderTransAdd + 1][128]

#define add_transparent_ent(%1) 			gBSA_Transparents[((%1 - 1) / 32)] |= (1<<((%1 - 1) % 32))
#define del_transparent_ent(%1) 			gBSA_Transparents[((%1 - 1) / 32)] &= ~(1<<((%1 - 1) % 32))
#define  is_transparent_ent(%1)				(gBSA_Transparents[((%1 - 1) / 32)] & (1<<((%1 - 1) % 32)))
#define add_solid_ent(%1) 					gBSA_Solids[((%1 - 1) / 32)] |= (1<<((%1 - 1) % 32))
#define del_solid_ent(%1) 					gBSA_Solids[((%1 - 1) / 32)] &= ~(1<<((%1 - 1) % 32))
#define  is_solid_ent(%1)					(gBSA_Solids[((%1 - 1) / 32)] & (1<<((%1 - 1) % 32)))
#define add_render(%0,%1) 					gBSA_RenderInfo[%0][((%1 - 1) / 32)] |= (1<<((%1 - 1) % 32))
#define del_render(%0,%1) 					gBSA_RenderInfo[%0][((%1 - 1) / 32)] &= ~(1<<((%1 - 1) % 32))
#define has_render(%0,%1)					(gBSA_RenderInfo[%0][((%1 - 1) / 32)] & (1<<((%1 - 1) % 32)))

#define make_GlassType(%0)					set_pev(%0, pev_rendermode, kRenderTransTexture)

public plugin_precache()
{
	register_forward(FM_Spawn, "pfw_spawn", 1)
}

public pfw_spawn(ent)
{
	if (!pev_valid(ent))
		return FMRES_IGNORED
	
	new rendermode, Float:renderamt
	
	rendermode = pev(ent, pev_rendermode)
	pev(ent, pev_renderamt, renderamt)
	
	if (((rendermode == kRenderTransColor || rendermode == kRenderGlow || rendermode == kRenderTransTexture) && renderamt < 255.0) || (rendermode == kRenderTransAdd))
	{
		add_transparent_ent(ent)
		setOriginalRenderMode(ent, rendermode)
		make_GlassType(ent)
	}
	
	return FMRES_IGNORED
}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar("trwb_version", VERSION, FCVAR_SPONLY | FCVAR_SERVER)
	
	gPCV_enable     	= register_cvar("trw_enable",					"1")
	gPCV_ignore_team 	= register_cvar("trw_ignore_team",				"1")
	gPCV_blockents  	= register_cvar("trw_block_ents",				"1")
	gPCV_fovcheck  		= register_cvar("trw_fov_check",				"1")
	gPCV_target   		= register_cvar("trw_target_check", 			"1")
	gPCV_smooth	   		= register_cvar("trw_smooth_check", 			"1")
	gPCV_texture    	= register_cvar("trw_textureallow", 			"1")
	gPCV_calcs			= register_cvar("trw_calculations", 			"2")
	gPCV_distort		= register_cvar("trw_player_distort_radius", 	"1500")
	gPCV_edistort		= register_cvar("trw_entity_distort_radius", 	"500")
	
	register_forward(FM_CheckVisibility,"fw_radius_checkvisibility"	,0)
	register_forward(FM_AddToFullPack,	"fw_radius_addtofullpack"	,0)
	register_forward(FM_AddToFullPack,	"pfw_check_addtofullpack"	,1)
	register_forward(FM_AddToFullPack,	"pfw_rndmd_addtofullpack"	,1)
	register_forward(FM_TraceLine,		"pfw_traceline"				,1)
	register_forward(FM_SetView,		"fw_setview"				,0)
	
	RegisterHam(Ham_Spawn, "player", "pfw_alive_handle", 1)
	RegisterHam(Ham_Killed, "player", "pfw_alive_handle", 1)
	
	register_event("CurWeapon", "event_active_weapon", "be")
	
	register_message(get_user_msgid("ClCorpse"), "message_clcorpse")
	
	gTraceHandle = create_tr2()
	
	gI_MaxPlayers = get_maxplayers()
	
	for (new i=1; i<=gI_MaxPlayers; i++)
	{
		add_solid_ent(i)
		gEP_ViewEnt[i] = i
	}
	
}

public plugin_end()
{
	free_tr2(gTraceHandle)
}

public client_connect(id)
{
	del_user_property(id, PROP_ALIVE)
	del_user_property(id, PROP_CONNECT)
	gBSP_IgnoreOnce[id] = 0
	gBSP_IgnoreTwo[id] = 0
}

// #define ignore_bots // Uncomment this if you want the plugin to simulate transmision with bots
public client_putinserver(id)
{
#if defined ignore_bots
	del_user_property(id, PROP_BOT)
#else
	if (is_user_bot(id))
		add_user_property(id, PROP_BOT)
	else
		del_user_property(id, PROP_BOT)
#endif
	
	add_user_property(id, PROP_CONNECT)
}

public client_disconnect(id)
{
	del_user_property(id, PROP_CONNECT)
	del_user_property(id, PROP_ALIVE)
	del_user_property(id, PROP_BOT)
}

public message_clcorpse(msg_id, msg_dest, entity)
{
	if (!has_user_property(get_msg_arg_int(12), PROP_CONNECT))
		return PLUGIN_HANDLED
	
	return PLUGIN_CONTINUE
}

public event_active_weapon(id)
{
	gCCV_enable 	   	= get_pcvar_num(gPCV_enable)
	gCCV_ignore_team  	= get_pcvar_num(gPCV_ignore_team)
	gCCV_blockents 	  	= get_pcvar_num(gPCV_blockents)
	gCCV_fovcheck 	   	= get_pcvar_num(gPCV_fovcheck)
	gCCV_target 	   	= get_pcvar_num(gPCV_target)
	gCCV_smooth 	   	= get_pcvar_num(gPCV_smooth)
	gCCV_texture 	   	= get_pcvar_num(gPCV_texture)
	gCCV_calcs 	  	   	= get_pcvar_num(gPCV_calcs)
	gCCV_distortRadius 	= get_pcvar_float(gPCV_distort)
	gCCV_distortERadius	= get_pcvar_float(gPCV_edistort)
	
	if (read_data(1) == 1)
	{
		gEP_Weapon[id] = read_data(2)
		
		if (gEP_Weapon[id] < CSW_P228 || gEP_Weapon[id] > CSW_P90)
		{
			gEP_Weapon[id] = CSW_KNIFE
		}
		
		gEP_Team[id] = _:cs_get_user_team(id)
	}
	
	return PLUGIN_CONTINUE
}
public fw_setview(id, attachent)
{
	gEP_ViewEnt[id] = attachent
	
	return FMRES_IGNORED
}


public pfw_alive_handle(id)
{
	if (!is_user_alive(id))
	{
		del_user_property(id, PROP_ALIVE)
	}
	else
	{
		add_user_property(id, PROP_ALIVE)
		
		gBSP_Targets[id] = 0
		gBSP_AddOffset[id] = ~0
	}
}

public fw_radius_addtofullpack(es, e, ent, host, flags, player, set)
{
	if (!gCCV_enable || (!player && !gCCV_blockents))
		return FMRES_IGNORED
	
	if (!has_user_property(host, PROP_CONNECT))
		return FMRES_IGNORED
	
	if (!has_user_property(host, PROP_ALIVE))
		return FMRES_IGNORED
	
	if (has_user_property(host, PROP_BOT) || gEP_Team[host] == _:CS_TEAM_SPECTATOR || gEP_Team[host] == _:CS_TEAM_UNASSIGNED)
		return FMRES_IGNORED
	
	if (!player)
	{
		if (!pev_valid(ent))
			return FMRES_IGNORED
			
		if (entity_range(ent,host) < gCCV_distortERadius)
			gEP_Visibility[host] = ent
		
		return FMRES_IGNORED
	}
	
	if (host == ent)
		return FMRES_IGNORED
	
	if (!has_user_property(ent, PROP_CONNECT))
		return FMRES_IGNORED
	
	if (!has_user_property(ent, PROP_ALIVE))
		return FMRES_IGNORED
	
	if (gCCV_ignore_team && gEP_Team[ent] == gEP_Team[host])
		return FMRES_IGNORED
	
	if (entity_range(ent,host) < gCCV_distortRadius)
		gEP_Visibility[host] = ent
	
	return FMRES_IGNORED
}

public fw_radius_checkvisibility(ent, set)
{
	for (new i=0;i<=MAX_PLAYERS;i++)
	{
		if (ent == gEP_Visibility[i])
		{
			gEP_Visibility[i] = 0
			forward_return(FMV_CELL, 1)
			return FMRES_SUPERCEDE
		}
	}
	
	return FMRES_IGNORED
}

public pfw_check_addtofullpack(es, e, ent, host, flags, player, set)
{
	if (!gCCV_enable || (!player && !gCCV_blockents))
		return FMRES_IGNORED
	
	if (!has_user_property(host, PROP_CONNECT))
		return FMRES_IGNORED
	
	if (!has_user_property(host, PROP_ALIVE))
		return FMRES_IGNORED
	
	if (has_user_property(host, PROP_BOT) || gEP_Team[host] == _:CS_TEAM_SPECTATOR || gEP_Team[host] == _:CS_TEAM_UNASSIGNED)
		return FMRES_IGNORED
	
	if (!player)
	{
		if (!pev_valid(ent))
			return FMRES_IGNORED
		
		static class_name[10], Float:maxs[3], Float:mins[3]
		pev(ent, pev_classname, class_name, charsmax(class_name))
		
		if (equal(class_name, "grenade"))
		{
			if (gCCV_blockents != 1)
			{
				maxs[0] = 4.0
				maxs[1] = 4.0
				maxs[2] = 2.0
				mins[0] = 4.0
				mins[1] = 4.0
				mins[2] = 2.0
			}
		} 
		else if (equal(class_name, "weaponbox"))
		{
			if (gCCV_blockents != 1)
			{
				maxs[0] = 6.0
				maxs[1] = 6.0
				maxs[2] = 4.0
				mins[0] = 6.0
				mins[1] = 6.0
				mins[2] = 0.0
			}
		} 
		else if (equal(class_name, "armoury_e"))
		{
			if (gCCV_blockents != 1)
			{
				maxs[0] = 4.0
				maxs[1] = 4.0
				maxs[2] = 2.0
				mins[0] = 4.0
				mins[1] = 4.0
				mins[2] = 0.0
			}
		}
		else
		{
			return FMRES_IGNORED
		}
		
		static Float:origin[3], Float:end[3], Float:plane_vec[3], Float:normal[3]
		
		if ( gEP_ViewEnt[host] == host )
			pev(host, pev_origin, origin)
		else
			pev(gEP_ViewEnt[host], pev_origin, origin)
		
		if (gCCV_fovcheck)
		{
			pev(host, pev_v_angle, normal)
			angle_vector(normal, ANGLEVECTOR_FORWARD, normal)
			
			pev(ent, pev_origin, end)
			xs_vec_sub(end, origin, plane_vec)
			xs_vec_mul_scalar(plane_vec,  (1.0/xs_vec_len(plane_vec)), plane_vec)
			
			if (xs_vec_dot(plane_vec, normal) < 0)
			{
				set_es(es, ES_Origin, gV_BlockOrigin)
				return FMRES_IGNORED
			}
			
			if (gEP_ViewEnt[host] == host)
			{
				pev(host, pev_view_ofs, plane_vec)
				xs_vec_add(plane_vec, origin, origin)
			}
		}
		else
		{
			if (gEP_ViewEnt[host] == host)
			{
				pev(host, pev_view_ofs, end)
				
				xs_vec_add(end, origin, origin)
			}
			
			pev(ent, pev_origin, end)
		}
		
		if (is_point_visible(origin, end, ent))
			return FMRES_IGNORED
		
		if (gCCV_blockents != 1)
		{
			if (is_borderplane_visible(origin, end, mins, maxs, IGNORE_MONSTERS | IGNORE_GLASS, ent, 1.0))
				return FMRES_IGNORED
		}
		
		set_es(es, ES_Origin, gV_BlockOrigin)
		return FMRES_IGNORED
	}
	
	if (!has_user_property(ent, PROP_ALIVE))
		return FMRES_IGNORED
	
	if (gCCV_ignore_team && gEP_Team[ent] == gEP_Team[host])
		return FMRES_IGNORED
	
	if (host != ent)
	{
		if (can_IgnoreTwo(host, ent))
		{
			stop_IgnoreTwo(host,ent)
			make_IgnoreOnce(host, ent)
			return FMRES_IGNORED
		}
		
		if (can_IgnoreOnce(host, ent))
		{
			if (!has_OffsetBetween(host, ent))
			{
				add_OffsetBetween(host, ent)
				return FMRES_IGNORED
			}
			else
				stop_IgnoreOnce(host, ent)
			
			return FMRES_IGNORED 
		}
		
		if (gCCV_target)
		{
			if (is_TargetedPlayer(host, ent))
			{
				del_TargetedPlayer(host, ent)
				del_OffsetBetween(host, ent)
				
				return FMRES_IGNORED
			}
		}
		
		static Float:origin[3], Float:start[3], Float:end[3], Float:plane_vec[3], Float:normal[3], ignore_ent
		
		ignore_ent = host
		
		if (gEP_ViewEnt[host] == host)
			pev(host, pev_origin, origin)
		else
			pev(gEP_ViewEnt[host], pev_origin, origin)
		
		if (gCCV_fovcheck)
		{
			pev(host, pev_v_angle, normal)
			angle_vector(normal, ANGLEVECTOR_FORWARD, normal)
			
			pev(ent, pev_origin, end)
			xs_vec_sub(end, origin, plane_vec)
			xs_vec_mul_scalar(plane_vec,  (1.0 / xs_vec_len(plane_vec)), plane_vec)
			
			if (xs_vec_dot(plane_vec, normal) < 0)
			{
				add_OffsetBetween(host, ent)
				
				set_es(es, ES_Origin, gV_BlockOrigin)
			}
			
			if (gEP_ViewEnt[host] == host)
			{
				pev(host, pev_view_ofs, start)
				xs_vec_add(start, origin, start)
			}
			else
			{
				start = origin
			}
			
			if (gCCV_smooth && has_OffsetBetween(host, ent))
			{
				pev(host, pev_velocity, origin)
				
				if (!xs_vec_equal(origin, Float:{0.0, 0.0, 0.0}))
				{
					xs_vec_mul_scalar(origin, FRAME_OFFSET_CONSTANT, origin)
					
					xs_vec_add(start, origin, start)
				}
				
				pev(ent, pev_velocity, origin)
				
				if (!xs_vec_equal(origin, Float:{0.0, 0.0, 0.0}))
				{
					xs_vec_mul_scalar(origin, FRAME_OFFSET_CONSTANT, origin)
					
					xs_vec_add(origin, end, origin)
				}
				else
				{
					origin = end
				}
			}
			else
			{
				origin = end
			}
		}
		else
		{
			if (gEP_ViewEnt[host] == host)
			{
				pev(host, pev_view_ofs, start)
				xs_vec_add(start, origin, start)
			}
			else
			{
				start = origin
			}
			
			pev(ent, pev_origin, end)
			
			if (gCCV_smooth)
			{
				pev(host, pev_velocity, origin)
				
				if (!xs_vec_equal(origin, Float:{0.0, 0.0, 0.0}))
				{
					xs_vec_mul_scalar(origin, has_OffsetBetween(host, ent) ? FRAME_OFFSET_CONSTANT : -FRAME_OFFSET_CONSTANT, origin)
					
					xs_vec_add(start, origin, start)
				}
				
				pev(ent, pev_velocity, origin)
				
				if (!xs_vec_equal(origin, Float:{0.0, 0.0, 0.0}))
				{
					xs_vec_mul_scalar(origin, has_OffsetBetween(host, ent) ? FRAME_OFFSET_CONSTANT : -FRAME_OFFSET_CONSTANT, origin)
					
					xs_vec_add(origin, end, origin)
				}
				else
				{
					origin = end
				}
			}
			else
			{
				origin = end
			}
		}
		
		// If origin is visible don't do anything
		if (gCCV_texture)
		{
			if (is_point_visible_texture(start, origin, ignore_ent))
			{
				del_OffsetBetween(host, ent)
				return FMRES_IGNORED
			}
		}
		else
		{
			if (is_point_visible(start, origin, ignore_ent))
			{
				del_OffsetBetween(host, ent)
				return FMRES_IGNORED
			}
		}
		
		pev(ent, pev_view_ofs, end)
		xs_vec_add(end, origin, end)
		
		// If eye origin is visible don't do anything
		if (is_point_visible(start, end, ignore_ent))
		{
			del_OffsetBetween(host, ent)
			return FMRES_IGNORED
		}
		
		// Check gEP_Weapon point
		if (gF_WeaponEdge[gEP_Weapon[ent]] != 0.00)
		{
			xs_vec_mul_scalar(normal, gF_WeaponEdge[gEP_Weapon[ent]], normal)
			xs_vec_add(end, normal, end)
			
			// If gEP_Weapon head is visible don't do anything
			if (is_point_visible(start, end, ignore_ent))
			{
				del_OffsetBetween(host, ent)
				return FMRES_IGNORED
			}
		}
		
		static Float:maxs[3], Float:mins[3]
		pev(ent, pev_mins, mins)
		pev(ent, pev_maxs, maxs)
		
		mins[1] -= 2.0
		mins[0] -= 2.0
		maxs[1] += 2.0
		maxs[0] += 2.0
		
		for (new i=gCCV_calcs; i>0; i--)
		{
			if (is_borderplane_visible(start, origin, mins, maxs, IGNORE_MONSTERS| IGNORE_GLASS, ignore_ent, float(i)/float(gCCV_calcs)))
			{
				del_OffsetBetween(host, ent)
				return FMRES_IGNORED
			}
		}
		
		if (!has_OffsetBetween(host, ent))
		{
			make_IgnoreTwo(host, ent)
			return FMRES_IGNORED
		}
		
		// the player cannot be seen so we block the send channel
		set_es(es, ES_Origin, gV_BlockOrigin)
		return FMRES_IGNORED
	}
	
	return FMRES_IGNORED
}

public pfw_rndmd_addtofullpack(es, e, ent, host, flags, player, set)
{
	if (!gCCV_enable)
		return FMRES_IGNORED
	
	if (!has_user_property(host, PROP_CONNECT))
		return FMRES_IGNORED
	
	if (has_user_property(host, PROP_BOT))
		return FMRES_IGNORED
	
	if (!player && !gCCV_texture)
		return FMRES_IGNORED
	
	if (!pev_valid(ent))
		return FMRES_IGNORED
	
	if (is_transparent_ent(ent))
		set_es(es, ES_RenderMode, getOriginalRenderMode(ent))
	
	return FMRES_HANDLED
}

public pfw_traceline(Float:start[3], Float:end[3], cond, id, tr)
{
	if (!gCCV_enable)
		return FMRES_IGNORED
	
	if (id <= 0 || id > gI_MaxPlayers)
		return FMRES_IGNORED
	
	if (!has_user_property(id, PROP_CONNECT))
		return FMRES_IGNORED
	
	new target = get_tr(TR_pHit)
	
	if (!has_user_property(id, PROP_ALIVE))
	{
		gBSP_Targets[id] = 0
	}
	else if (is_user_alive(target))
	{
		new Float:vecend[3]
		get_tr(TR_vecEndPos, vecend)
		
		if (!is_visible_origin(id, vecend))
			return FMRES_IGNORED
		
		add_TargetedPlayer(id, target)
	} 
	else
	{
		if (target > 0)
			if (is_transparent_ent(target) || is_solid_ent(target))
				return FMRES_IGNORED
		
		new texture[2]
		if (trace_texture(target < 0 ? 0 : target, start, end, texture, 1))
		{
			if (texture[0] == '{')
			{
				add_transparent_ent(target)
				setOriginalRenderMode(target, -1)
				make_GlassType(target)
			}
		}
	}
	
	return FMRES_IGNORED
}

bool:is_point_visible(const Float:start[3], const Float:point[3], ignore_ent)
{
	engfunc(EngFunc_TraceLine, start, point, IGNORE_GLASS | IGNORE_MONSTERS, ignore_ent, gTraceHandle)

	static Float:fraction
	get_tr2(gTraceHandle, TR_flFraction, fraction)
	
	return (fraction == 1.0)
}

bool:is_point_visible_texture(Float:start[3], Float:point[3], ignore_ent)
{
	engfunc(EngFunc_TraceLine, start, point, IGNORE_GLASS | IGNORE_MONSTERS, ignore_ent, gTraceHandle)
	
	static ent
	ent = get_tr2(gTraceHandle, TR_pHit)

	static Float:fraction
	get_tr2(gTraceHandle, TR_flFraction, fraction)
	
	if (fraction != 1.0 && ent > gI_MaxPlayers)
	{
		if (!is_transparent_ent(ent) && !is_solid_ent(ent))
		{
			static texture_name[2]
			static Float:vec[3]
			xs_vec_sub(point, start, vec)
			xs_vec_mul_scalar(vec, (5000.0 / xs_vec_len(vec)), vec)
			xs_vec_add(start, vec, vec)
			
			if (trace_texture(ent, start, point, texture_name, charsmax(texture_name)))
			{
				if (equal(texture_name, "{"))
				{
					add_transparent_ent(ent)
					setOriginalRenderMode(ent, -1)
					make_GlassType(ent)
					
					static players[32], num, id, Float:origin[3]
					get_players(players, num, "a")
					
					for (new i=0;i<num;i++)
					{
						id = players[i]
						
						if ( pev(id,pev_groundentity) == ent )
						{
							pev(id, pev_origin, origin)
							
							origin[2] += 1.0
							
							set_pev(id, pev_origin, origin)
						}
					}
					
					ignore_ent = ent
					
					engfunc(EngFunc_TraceLine, start, point, IGNORE_GLASS | IGNORE_MONSTERS, ignore_ent, gTraceHandle)
					
					get_tr2(gTraceHandle, TR_flFraction, fraction)
					
					return (fraction == 1.0)
				}
				else
				{
					add_solid_ent(ent)
					
					return (fraction == 1.0)
				}
			}
		}
		else
		{
			if (is_solid_ent(ent))
			{
				return (fraction == 1.0)
			}
			else
			{
				ignore_ent = ent
				engfunc(EngFunc_TraceLine, start, point, IGNORE_GLASS | IGNORE_MONSTERS, ignore_ent, gTraceHandle)
				get_tr2(gTraceHandle, TR_flFraction, fraction)
				return (fraction == 1.0)
			}
		}
	}
	
	return (fraction == 1.0)
}

stock getOriginalRenderMode(ent)
{
	if (ent <= 0)
		return -1;
	
	for (new i=kRenderNormal;i<=kRenderTransAdd;i++)
	{
		if (has_render(i, ent))
			return i;
	}
	
	return -1;
}

stock setOriginalRenderMode(ent, rendermode = -1)
{
	if (rendermode < kRenderNormal || rendermode > kRenderTransAdd)
		rendermode = pev(ent, pev_rendermode)
	
	add_render(rendermode, ent)
	return 1
}

stock xs_vec_add(const Float:in1[], const Float:in2[], Float:out[])
{
	out[0] = in1[0] + in2[0];
	out[1] = in1[1] + in2[1];
	out[2] = in1[2] + in2[2];
}

stock xs_vec_sub(const Float:in1[], const Float:in2[], Float:out[])
{
	out[0] = in1[0] - in2[0];
	out[1] = in1[1] - in2[1];
	out[2] = in1[2] - in2[2];
}

stock xs_vec_mul_scalar(const Float:vec[], Float:scalar, Float:out[])
{
	out[0] = vec[0] * scalar;
	out[1] = vec[1] * scalar;
	out[2] = vec[2] * scalar;
}

stock Float:xs_vec_len(const Float:vec[3])
{
	return floatsqroot(vec[0]*vec[0] + vec[1]*vec[1] + vec[2]*vec[2]);
}

stock Float:xs_vec_dot(const Float:vec[3], const Float:vec2[3])
{
	return (vec[0]*vec2[0] + vec[1]*vec2[1] + vec[2]*vec2[2])
}

bool:xs_vec_equal(const Float:vec1[], const Float:vec2[])
{
	return (vec1[0] == vec2[0]) && (vec1[1] == vec2[1]) && (vec1[2] == vec2[2]);
}